#ifndef _SRCSTATE_RAMPUP_H_
#define _SRCSTATE_RAMPUP_H_

#include "AudioStack/SMT/clSrcState.h"

namespace AudioStack
{



/*!************************************************************************
 * FILE :         clSrcState_RampUp.h
 * SW-COMPONENT:  Audio Engine / Statemachine
 * DESCRIPTION:
 * CLASS:         RampUp, RampUpInit, RampUpRequesting
 *
 * The AudioSource can have the RampUp states:
 * - RampUp
 * - RampUpInit
 * - RampUpRequesting
 * The RampUp-State had to be devided into these sub-states due to the
 * following reasons:
 * 1) When a source is in rampUp state and an Off-request arrives,
 *    this off-request might not be confirmed by FC-Audio depending on
 *    if prev. play-request have already been confirmed.
 *    So it has to be differentiated, if FC-Audio already confirmed
 *    the prev. request or not.
 *    If not, we might not send an off again. Instead we have to
 *    create a manual confirmation on our own.
 * 2) The init-substate was introduced to facilitate the init-phase
 *    in audiosource, which have to prepare the players before requesting
 *    a play on FC-Audio.
 *    During this init-phase, an off-request also has to be confirmed manually
 *
 * AUTHOR:        CM-DI/PJ-VW34 Steinle
 * COPYRIGHT:     (c) 2006 Blaupunkt Werke
 *************************************************************************/

class clSrcState_RampUp : public clSrcState
{
public:
    clSrcState_RampUp() : clSrcState("rampup", AudioStates::RAMPUP){};
   virtual tVoid vMsg_OnDone(clAudioSource* pclAudioSource, tU32 u32UserData);
   virtual tVoid vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData);
   virtual tVoid vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData);
   virtual tVoid vMsg_On(clAudioSource* pclAudioSource, tU32 u32UserData);
   virtual tVoid vMsg_ServiceAvailable(clAudioSource* src, tU32 u32UserData);
};

}

#endif  //_SRCSTATE_RAMPUP_H_
